<?php
// 🌞 BUEN DÍA CON AUDIO - Romu Edition 😎
// Envía clima + 2 titulares CON FOTO + voz como archivo de audio a Telegram

date_default_timezone_set('America/Argentina/Cordoba');
setlocale(LC_TIME, 'es_AR.UTF-8', 'es_ES.UTF-8', 'spanish');

// --- CONFIG ---
$telegram_token = '7403117521:AAEGwGH86dvjergAXZ5VxgBQQOUZy-UorlU';
$chat_id = '6798345671';
$lat = -31.4167;
$lon = -64.1833;
$rss_url = "https://www.lavoz.com.ar/rss/portada.xml";
$tts_file = __DIR__ . "/buen_dia.mp3";
$intro = __DIR__ . '/intro_radio.mp3';
$final_with_intro = __DIR__ . '/buen_dia_radio.mp3';

// --- CLIMA ---
$weather_url = "https://api.open-meteo.com/v1/forecast?latitude=$lat&longitude=$lon&current_weather=true&daily=temperature_2m_max,temperature_2m_min,sunrise,sunset&timezone=auto";
$weather_json = @file_get_contents($weather_url);
$temp = $wind = $tmax = $tmin = $amanecer = $puesta = '?';
if ($weather_json) {
    $w = json_decode($weather_json, true);
    if (isset($w['current_weather'])) {
        $temp = $w['current_weather']['temperature'];
        $wind = $w['current_weather']['windspeed'];
    }
    if (isset($w['daily'])) {
        $tmax = $w['daily']['temperature_2m_max'][0];
        $tmin = $w['daily']['temperature_2m_min'][0];
        $amanecer = date('H:i', strtotime($w['daily']['sunrise'][0]));
        $puesta = date('H:i', strtotime($w['daily']['sunset'][0]));
    }
}

// --- NOTICIAS (2 primeras con foto) ---
$context = stream_context_create([
    "ssl" => ["verify_peer" => false, "verify_peer_name" => false],
    "http" => ["timeout" => 8, "user_agent" => "RomuBot/1.0"]
]);
$rss_xml = @file_get_contents($rss_url, false, $context);
$noticias = [];

if ($rss_xml) {
    $rss = @simplexml_load_string($rss_xml, "SimpleXMLElement", LIBXML_NOCDATA);
    if ($rss && isset($rss->channel->item)) {
        for ($i = 0; $i < 2 && $i < count($rss->channel->item); $i++) {
            $item = $rss->channel->item[$i];
            $titulo = mb_strimwidth(trim((string)$item->title), 0, 120, "…", "UTF-8");
            $desc_raw = (string)($item->children('content', true)->encoded ?? $item->description ?? '');
            $desc = strip_tags(preg_replace('/\s+/', ' ', $desc_raw));
            $desc = mb_strimwidth($desc, 0, 180, "…", "UTF-8");
            $link = (string)$item->link;

            $imagen = null;
            if ($item->children('media', true)->content) {
                $media = $item->children('media', true)->content;
                $imagen = (string)$media->attributes()->url;
            }
            if (!$imagen && $item->enclosure) {
                $enc_type = (string)$item->enclosure->attributes()->type;
                if (strpos($enc_type, 'image') !== false) {
                    $imagen = (string)$item->enclosure->attributes()->url;
                }
            }
            if (!$imagen) {
                preg_match('/<img[^>]+src=["\']([^"\']+)["\'][^>]*>/i', $desc_raw, $match);
                if (isset($match[1])) {
                    $imagen = $match[1];
                }
            }

            $noticias[] = [
                'titulo' => $titulo,
                'desc' => $desc,
                'link' => $link,
                'imagen' => $imagen
            ];
        }
    }
}
if (empty($noticias)) {
    $noticias[] = [
        'titulo' => 'Sin noticias disponibles',
        'desc' => 'No se pudieron cargar las noticias del día',
        'link' => '',
        'imagen' => null
    ];
}

// --- MENSAJE TEXTO ---
$hora = date('H:i');
$fecha = ucfirst(strftime('%A %d de %B de %Y'));
$msg  = "🌅 <b>Buen día, Romu!</b> 🌅\n";
$msg .= "Hoy es <b>$fecha</b> y son las <b>$hora</b>.\n\n";
$msg .= "🌡️ Temp actual: <b>{$temp}°C</b>\n";
$msg .= "↕️ Máx: {$tmax}°C · Mín: {$tmin}°C\n";
$msg .= "🌅 Amanecer: {$amanecer} · 🌇 Puesta: {$puesta}\n";
$msg .= "💨 Viento: {$wind} km/h\n\n";
$msg .= "RomuBot te desea un excelente día.";

// --- ENVIAR MENSAJE DE CLIMA ---
$ch = curl_init("https://api.telegram.org/bot{$telegram_token}/sendMessage");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, [
    'chat_id' => $chat_id,
    'text' => $msg,
    'parse_mode' => 'HTML'
]);
curl_exec($ch);
curl_close($ch);

// --- ENVIAR CADA NOTICIA CON FOTO ---
foreach ($noticias as $idx => $noticia) {
    $num = $idx + 1;
    $msg_noticia = "📰 <b>Noticia {$num}:</b>\n\n";
    $msg_noticia .= "<b>{$noticia['titulo']}</b>\n\n";
    $msg_noticia .= "{$noticia['desc']}\n\n";
    if ($noticia['link']) $msg_noticia .= "<a href=\"{$noticia['link']}\">Ver más</a>";
    
    if ($noticia['imagen']) {
        $ch = curl_init("https://api.telegram.org/bot{$telegram_token}/sendPhoto");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, [
            'chat_id' => $chat_id,
            'photo' => $noticia['imagen'],
            'caption' => $msg_noticia,
            'parse_mode' => 'HTML'
        ]);
        curl_exec($ch);
        curl_close($ch);
    } else {
        $ch = curl_init("https://api.telegram.org/bot{$telegram_token}/sendMessage");
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, [
            'chat_id' => $chat_id,
            'text' => $msg_noticia,
            'parse_mode' => 'HTML'
        ]);
        curl_exec($ch);
        curl_close($ch);
    }
    usleep(300000);
}

// --- TTS ---
$text_to_read = "Buen día, Romu. Hoy es $fecha. La temperatura actual es de $temp grados. Máxima $tmax, mínima $tmin. ";
foreach ($noticias as $idx => $noticia) {
    $num = $idx + 1;
    $text_to_read .= "Noticia {$num}: {$noticia['titulo']}. {$noticia['desc']}. ";
}
$chunks = str_split($text_to_read, 180);
$tmp_files = [];
foreach ($chunks as $i => $chunk) {
    $encoded = urlencode($chunk);
    $tts_url = "https://translate.google.com/translate_tts?ie=UTF-8&q={$encoded}&tl=es&client=tw-ob";
    $tmp_path = __DIR__ . "/tts_part_{$i}.mp3";
    $audio = @file_get_contents($tts_url);
    if ($audio) {
        file_put_contents($tmp_path, $audio);
        $tmp_files[] = $tmp_path;
    }
    usleep(200000);
}
$final = fopen($tts_file, 'w');
foreach ($tmp_files as $file) {
    fwrite($final, file_get_contents($file));
    unlink($file);
}
fclose($final);

// --- ENVIAR AUDIO ---
$ch = curl_init("https://api.telegram.org/bot{$telegram_token}/sendAudio");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, [
    'chat_id' => $chat_id,
    'audio' => new CURLFile($tts_file),
    'caption' => "🎙️ Resumen hablado del día 🌞"
]);
curl_exec($ch);
curl_close($ch);

// --- INTRO RADIO ---
$final = fopen($final_with_intro, 'w');
if (file_exists($intro)) fwrite($final, file_get_contents($intro));
fwrite($final, file_get_contents($tts_file));
fclose($final);
$ch = curl_init("https://api.telegram.org/bot{$telegram_token}/sendAudio");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, [
    'chat_id' => $chat_id,
    'audio' => new CURLFile($final_with_intro),
    'caption' => "🎙️ RomuBot Morning Edition ☕"
]);
curl_exec($ch);
curl_close($ch);

// --- LOG ---
file_put_contents(__DIR__ . '/buen_dia_tts.log', date('Y-m-d H:i:s')." -> texto + 2 noticias con foto + audio enviado\n", FILE_APPEND);
echo "✅ Enviado texto + 2 noticias con foto + audio a Telegram.\n";
?>
